<?php
/* --------------------------------------------------------------
 SimpleCustomerServiceProvider.php 2020-02-14
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Customer;

use Doctrine\DBAL\Connection;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;

/**
 * Class SimpleCustomerServiceProvider
 * @package Gambio\Admin\Customer
 */
class SimpleCustomerServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            SimpleCustomerService::class
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->share(SimpleCustomerService::class)->addArgument(Connection::class);
    }
}